<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;
    protected $fillable = array('service_id', 'sub_service_id', 'type', 'store_id', 'start_city_id', 'end_city_id', 'client_latitude', 'client_longitude', 'target_latitude', 'target_longitude', 'handed_name', 'phone', 'status', 'delivery_term', 'days_number', 'payment_method', 'description', 'for_other_one', 'delivery_price', 'bill_price', 'coupon_cut', 'net', 'commission_status', 'commission', 'commission_present', 'delivery_cancel_expired_date', 'natunalID');

    public function contacts()
    {
        return $this->hasMany('App\Models\Contact');
    }

    public function bill()
    {
        return $this->hasMany('App\Models\Bill');
    }

    public function coupon()
    {
        return $this->belongsTo('App\Models\Coupon');
    }

    public function service()
    {
        return $this->belongsTo('App\Models\Service', 'service_id');
    }

    public function subService()
    {
        return $this->belongsTo('App\Models\Service', 'sub_service_id');
    }

    public function deliveries()
    {
        return $this->belongsToMany('App\Models\Deliveriy');
    }

    public function clientReviews()
    {
        return $this->hasMany('App\Models\ClientReview');
    }

    public function serviceProviderReviews()
    {
        return $this->hasMany('App\Models\Review');
    }

    public function store()
    {
        return $this->belongsTo('App\Models\Store');
    }

    public function startCity()
    {
        return $this->belongsTo('App\Models\City', 'start_city_id');
    }

    public function endCity()
    {
        return $this->belongsTo('App\Models\City', 'end_city_id');
    }

}